import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import randomChannelsScenario from 'web-client/mirage/scenarios/random-channels';
import RandomPage from 'web-client/tests/pages/directory/channels/random';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

moduleForAcceptance('Acceptance | directory/all/random', {
  beforeEach() {
    this.page = RandomPage.create();
    randomChannelsScenario(this.server);
    stubLogin({ login: 'twitch' });
  }
});

test("/directory/all/random tracks page latency by reporting when it's ready to accept user interaction", function(assert) {
  assert.expect(2);
  visit(this.page.url());

  andThen(() => {
    assert.trackInteractivity('directory.channels.random');
  });

  andThen(() => {
    assert.trackBenchmarkEvent('complete_transition');
  });
});
