import { test } from 'qunit';
import moduleForAcceptance from '../../helpers/module-for-acceptance';
import CommunitiesDirectoryPage from '../../pages/directory/communities';

let page;

moduleForAcceptance('Acceptance | /directory/communities', {
  beforeEach() {
    page = CommunitiesDirectoryPage.create();
  }
});

test('tracks interactivity', function (assert) {
  assert.expect(2);

  visit(page.url());

  andThen(() => {
    assert.trackInteractivity('directory.communities');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});
