import { test } from 'qunit';
import moduleForAcceptance from '../../helpers/module-for-acceptance';
import channelDirectoryScenario from 'web-client/mirage/scenarios/channel-directory';
import communityScenario from 'web-client/mirage/scenarios/community';
import DirectoryCreativePage from '../../pages/directory/creative';

let page;

moduleForAcceptance('Acceptance-Directory Creative', {
  beforeEach() {
    page = DirectoryCreativePage.create();
    channelDirectoryScenario(this.server);
    communityScenario(this.server);
    this.server.create('game');
  }
});

test('visiting creative directory page', function (assert) {
  assert.expect(5);

  visit(page.url());

  andThen(function () {
    assert.equal(currentURL(), '/directory/game/Creative');
    assert.equal(currentRouteName(), 'directory.creative.index');
    assert.equal(find(page.title()).length, 1, 'has header');
    assert.equal(page.headTitle(), 'Creative - Twitch', 'has page title');
    assert.equal(page.canonicalUrl(), 'https://www.twitch.tv/directory/game/Creative', 'Canonical URL present');
  });
});

test('visiting lowercase creative directory page', function (assert) {
  assert.expect(4);

  visit(page.url().toLowerCase());

  andThen(function () {
    assert.equal(currentURL(), '/directory/game/Creative');
    assert.equal(currentRouteName(), 'directory.creative.index');
    assert.equal(find(page.title()).length, 1, 'has Title');
    assert.equal(page.canonicalUrl(), 'https://www.twitch.tv/directory/game/Creative', 'Canonical URL present');
  });
});
