import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import channelDirectoryScenario from 'web-client/mirage/scenarios/channel-directory';
import communityScenario from 'web-client/mirage/scenarios/community';
import DirectoryCreativePage from 'web-client/tests/pages/directory/creative';

let page;

const url = '/directory/game/Creative/illustration';

moduleForAcceptance('Acceptance-Directory Creative Hashtag', {
  beforeEach() {
    page = DirectoryCreativePage.create();
    channelDirectoryScenario(this.server);
    communityScenario(this.server);
    this.server.create('game');
  }
});


test('visiting creative directory page', function (assert) {
  assert.expect(5);

  visit(url);

  andThen(function () {
    assert.equal(currentURL(), url);
    assert.equal(currentRouteName(), 'directory.creative.hashtag.index');
    assert.equal(find(page.subtitle('illustration')).length, 1, 'has header');
    assert.equal(page.headTitle(), 'Illustration - Creative - Twitch', 'has page title');
    assert.equal(page.canonicalUrl(), `https://www.twitch.tv${url}`, 'Canonical URL present');
  });
});
