import { test } from 'qunit';
import moduleForAcceptance from '../../helpers/module-for-acceptance';
import channelDirectoryScenario from 'web-client/mirage/scenarios/channel-directory';
import DirectoryCSGOPage from '../../pages/directory/csgo';

let page;
let gameName = 'Counter-Strike: Global Offensive';
moduleForAcceptance('Acceptance-Directory CSGO', {
  beforeEach() {
    page = DirectoryCSGOPage.create();
    channelDirectoryScenario(this.server);

    this.server.create('game', {
      name: gameName
    });
  }
});

test('visiting csgo directory page', function (assert) {
  assert.expect(5);

  visit(page.url());

  andThen(function () {
    assert.equal(currentURL(), page.url());
    assert.equal(currentRouteName(), 'directory.csgo.channels.index');
    assert.equal(find(page.title()).length, 1, 'has Title');
    assert.equal(find(page.map()).length, 1, 'has custom CSGO map');
    assert.equal(page.headTitle(), `${gameName} - Twitch`, 'has title tag in head');
  });
});

test("tracks page latency by reporting when it's ready to accept user interaction", function (assert) {
  assert.expect(2);

  visit(page.url());

  andThen(() => {
    assert.trackInteractivity('directory.csgo.channels.index');
  });

  andThen(() => {
    assert.trackBenchmarkEvent('complete_transition');
  });
});

test('visiting `/directory/game/Counter-Strike: global Offensive` (case mismatch)', function (assert) {
  assert.expect(4);

  visit('/directory/game/Counter-Strike: global Offensive');

  andThen(function () {
    assert.equal(currentURL(), page.url());
    assert.equal(currentRouteName(), 'directory.csgo.channels.index');
    assert.equal(find(page.title()).length, 1, 'has Title');
    assert.equal(find(page.map()).length, 1, 'has custom CSGO map');
  });
});
