import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import FollowingGamesPage from 'web-client/tests/pages/directory/following-games';
import { followingLoggedOutMessage } from 'web-client/tests/pages/directory/following';
import testForLoginModal from 'web-client/tests/helpers/test-for-login-modal';
import { stubLogin } from '../../helpers/stub-login';

moduleForAcceptance('Acceptance | directory/following/games [logged out]', {
  beforeEach() {
    this.page = FollowingGamesPage.create();
  }
});

testForLoginModal({
  url: '/directory/following/games',
  testFunction: test,
  expectedText: followingLoggedOutMessage
});

test('tracks interactivity [logged out]', function (assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(function () {
    assert.trackInteractivity('directory.following.games');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});

moduleForAcceptance('Acceptance | directory/following/games [logged in]', {
  beforeEach() {
    this.page = FollowingGamesPage.create();
    stubLogin();
  }
});

test('clicking a followed game sends a tracking event', function(assert) {
  assert.expect(3);

  let game = this.server.create('game', {name: 'not-creative'});
  this.server.create('gameFollow', {gameId: game.id});

  let gameIndex = 0;
  let expectedEventData = {
    tab: 'games',
    num_games: 1,
    section: 'games',
    position: gameIndex
  };

  visit(this.page.url());
  click(this.page.gameItem(gameIndex));

  andThen(() => {
    assert.trackEvent('follow_directory_click', expectedEventData);
    assert.equal(currentRouteName(), 'directory.game.index');
    assert.equal(currentURL(), `/directory/game/${game.name}`);
  });
});

test('tracks interactivity', function (assert) {
  assert.expect(2);

  let game = this.server.create('game', {name: 'not-creative'});
  this.server.create('gameFollow', {gameId: game.id});

  visit(this.page.url());

  andThen(function () {
    assert.trackInteractivity('directory.following.games');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});
