import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import FollowingLivePage from 'web-client/tests/pages/directory/following-live';
import { followingLoggedOutMessage } from 'web-client/tests/pages/directory/following';
import testForLoginModal from 'web-client/tests/helpers/test-for-login-modal';
import channelScenario from 'web-client/mirage/scenarios/channel';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

moduleForAcceptance('Acceptance | directory/following/live [logged out]', {
  beforeEach() {
    this.page = FollowingLivePage.create();
  }
});

testForLoginModal({
  url: '/directory/following/live',
  testFunction: test,
  expectedText: followingLoggedOutMessage
});

test('tracks interactivity [logged out]', function (assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(function () {
    assert.trackInteractivity('directory.following.channels');
  });

  andThen(function () { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});

let channel, channelIndex, expectedData;

moduleForAcceptance('Acceptance | directory/following/live [logged in]', {
  beforeEach() {
    this.page = FollowingLivePage.create();
    this.user = stubLogin();

    // Create a channel with a stream
    channel = channelScenario(this.server);

    // Create a "follow" between the logged-in user and the channel so
    // that it shows up on the following/live page
    this.server.create('follow', {
      userName: this.user.name,
      channelName: channel.name,
      channel
    });

    channelIndex = 0;
    expectedData = {
      section: 'channels',
      tab: 'channels',
      num_channels: 1,
      position: channelIndex,
      channel: channel.name
    };
  }
});

test('clicking channel fires follow_directory_click tracking event', function (assert) {
  assert.expect(3);

  visit(this.page.url());

  andThen(() => {
    click(this.page.channelItemLink(channelIndex));
  });

  andThen(() => {
    assert.trackEvent('follow_directory_click', expectedData);
    assert.equal(currentRouteName(), 'channel.index.index');
    assert.equal(currentURL(), `/${channel.name}`);
  });
});

test('tracks interactivity', function (assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(function () {
    assert.trackInteractivity('directory.following.channels');
  });

  andThen(function () { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});
