import { test } from 'qunit';
import moduleForAcceptance from '../../helpers/module-for-acceptance';
import FollowingDirectoryPage, { followingLoggedOutMessage } from 'web-client/tests/pages/directory/following';
import testForLoginModal from 'web-client/tests/helpers/test-for-login-modal';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import videoAppealScenario from 'web-client/mirage/scenarios/video-appeal';
import channelScenario from 'web-client/mirage/scenarios/channel';
import { UPLOAD_TYPE_PARAM } from 'web-client/utilities/video/types';

moduleForAcceptance('Acceptance | /directory/following [logged in]', {
  beforeEach() {
    this.page = FollowingDirectoryPage.create();
    stubLogin();
  }
});

test('is prompted to follow channels and games', function (assert) {
  assert.expect(4);

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/directory/following');
    assert.equal(currentRouteName(), 'directory.following.index');

    assert.ok(this.page.hasFollowChannelFTUX(), 'has follow channel ftux');
    assert.ok(this.page.hasFollowGameFTUX(), 'has follow game ftux');
  });
});

test('after clicking "Find out more" user can follow a game', function (assert) {
  assert.expect(5);

  /* Ensure there is a game on the page to follow */
  let game = this.server.create('game');

  let fetchFollowsCount = () => this.server.schema.gameFollows.all().models.length;
  let followCount = fetchFollowsCount();

  visit(this.page.url());

  click('a.button:contains(Find out more)');
  andThen(() => {
    assert.strictEqual(fetchFollowsCount(), followCount, 'precond - no follows requested');
    assert.ok(this.page.hasFollowGamePopup(), 'Popup is open');
  });

  click(this.page.gameBoxSelector);
  andThen(() => {
    assert.strictEqual(fetchFollowsCount(), followCount+1, 'Follow requested');
  });

  click(this.page.closeButtonSelector);
  andThen(() => {
    assert.notOk(this.page.hasFollowGamePopup(), 'Popup is closed');
    assert.ok(this.page.hasGameIconFor(game.name), `Displays game ${game.name}`);
  });
});

test('latest uploads video click goes to corresponding video page', function(assert) {
  assert.expect(2);

  this.experiments.use({ 'VOD_UPLOAD_UNITS': 'experiment' });
  videoAppealScenario(this.server, 1);

  let channel = channelScenario(this.server);
  let video = this.server.create('video', { channel, broadcast_type: UPLOAD_TYPE_PARAM });
  this.server.create('video-follow', { videoId: video.id });

  visit(this.page.url());

  click(this.page.latestUploadsVideoAtIndex(0));

  andThen(() => {
    assert.equal(currentRouteName(), 'videos');
    assert.equal(currentURL(), `/videos/${video.id}`);
  });
});

test('tracks interactivity', function (assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(function () {
    assert.trackInteractivity('directory.following.index');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});

moduleForAcceptance('Acceptance | /directory/following [logged out]', {
  beforeEach() {
    this.page = FollowingDirectoryPage.create();
  }
});

testForLoginModal({
  url: '/directory/following',
  testFunction: test,
  expectedText: followingLoggedOutMessage
});

test('tracks interactivity [logged out]', function (assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(function () {
    assert.trackInteractivity('directory.following.index');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});
