import { test } from 'qunit';
import moduleForAcceptance from '../../../helpers/module-for-acceptance';
import channelDirectoryScenario from 'web-client/mirage/scenarios/channel-directory';
import DirectoryGameVideosPage from '../../../pages/directory/game/videos';
import { GAME_NAME as name } from '../../../pages/directory/game/videos';
import channelScenario from 'web-client/mirage/scenarios/channel';
import { UPLOAD_TYPE_PARAM } from 'web-client/utilities/video/types';

let page;

moduleForAcceptance('Acceptance | directory/game/videos', {
  beforeEach() {
    page = DirectoryGameVideosPage.create();
    channelDirectoryScenario(this.server);

    this.server.create('game', { name });
  }
});

test(`visiting "${name}" directory game does not show trending (insufficient videos)`, function (assert) {
  assert.expect(4);

  let channel = channelScenario(this.server, name);
  this.server.create('video', {channel});
  this.server.create('video', {channel});
  this.server.create('video', {channel});

  visit(page.url());

  andThen(function () {
    assert.equal(currentURL(), page.url());
    assert.equal(currentRouteName(), 'directory.game.videos.video-type');
    assert.equal(find(page.title()).length, 1, 'has Title');
    assert.equal(find(page.videos()).length, 3, 'has 3 videos and no uploads');
  });
});

test(`visiting "${name}" directory game does not show trending (insufficient viewcount)`, function (assert) {
  assert.expect(4);

  let channel = channelScenario(this.server, name);
  this.server.create('video', {channel, broadcast_type: UPLOAD_TYPE_PARAM, views: 5});
  this.server.create('video', {channel, broadcast_type: UPLOAD_TYPE_PARAM, views: 5});
  this.server.create('video', {channel, broadcast_type: UPLOAD_TYPE_PARAM, views: 5});
  this.server.create('video', {channel, broadcast_type: UPLOAD_TYPE_PARAM, views: 5});
  this.server.create('video', {channel, broadcast_type: UPLOAD_TYPE_PARAM, views: 4});

  visit(page.url());

  andThen(function () {
    assert.equal(currentURL(), page.url());
    assert.equal(currentRouteName(), 'directory.game.videos.video-type');
    assert.equal(find(page.title()).length, 1, 'has Title');
    assert.equal(find(page.videos()).length, 5, 'has 5 videos');
  });
});

test(`visiting "${name}" directory game shows trending`, function (assert) {
  assert.expect(4);

  let channel = channelScenario(this.server, name);
  this.server.create('video', {channel, broadcast_type: UPLOAD_TYPE_PARAM, views: 5});
  this.server.create('video', {channel, broadcast_type: UPLOAD_TYPE_PARAM, views: 5});
  this.server.create('video', {channel, broadcast_type: UPLOAD_TYPE_PARAM, views: 5});
  this.server.create('video', {channel, broadcast_type: UPLOAD_TYPE_PARAM, views: 5});
  this.server.create('video', {channel, broadcast_type: UPLOAD_TYPE_PARAM, views: 5});

  visit(page.url());

  andThen(function () {
    assert.equal(currentURL(), page.url());
    assert.equal(currentRouteName(), 'directory.game.videos.video-type');
    assert.equal(find(page.title()).length, 1, 'has Title');
    assert.equal(find(page.videos()).length, 10, 'has 5 videos 5 uploads');
  });
});


test(`visiting "${name}" directory game goes to all videos page showing video`, function (assert) {
  assert.expect(4);

  visit(page.url());
  let channel = channelScenario(this.server, name);
  this.server.create('video', {channel});

  andThen(function () {
    assert.equal(currentURL(), page.url());
    assert.equal(currentRouteName(), 'directory.game.videos.video-type');
    assert.equal(find(page.title()).length, 1, 'has Title');
    assert.equal(find(page.videos()).length, 1, 'has 1 video');
  });
});
