import { test } from 'qunit';
import moduleForAcceptance from '../../helpers/module-for-acceptance';
import DirectoryGamesPage from '../../pages/directory/games';

let page, game;

moduleForAcceptance('Acceptance-Directory Games', {
  beforeEach() {
    page = DirectoryGamesPage.create();

    this.server.create('game', {
      name: 'Destiny'
    });

    game = this.server.create('game', {
      name: 'Broforce'
    });
  }
});

test('visiting /directory page', function (assert) {
  assert.expect(5);

  visit(page.url());

  andThen(function () {
    assert.equal(currentURL(), '/directory');
    assert.equal(currentRouteName(), 'directory.games');
    assert.equal(find(page.title()).length, 1, 'has Title');
    assert.equal(find(page.gameThumbs()).length, 2, 'has games');
    assert.equal(find(page.thumbLink(game.name)).length, 1, 'can find created game');
  });
});

test('clicking thumbnail in /directory page redirects to /directory/game/${name}', function (assert) {
  assert.expect(2);

  visit(page.url());

  click(page.thumbLink(game.name));

  andThen(function() {
    assert.equal(currentURL(), '/directory/game/Broforce');
    assert.equal(currentRouteName(), 'directory.game.index');
  });
});
test('tracks interactivity', function (assert) {
  assert.expect(2);

  visit(page.url());

  andThen(() => {
    assert.trackInteractivity('directory.games');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});
