import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import channelScenario from 'web-client/mirage/scenarios/channel';
import followScenario from 'web-client/mirage/scenarios/follow';
import hostScenario from 'web-client/mirage/scenarios/host';
import HostPage from 'web-client/tests/pages/directory/host';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

let page;

moduleForAcceptance('Acceptance | directory/following/hosts', {
  beforeEach() {
    page = HostPage.create();
    channelScenario(this.server, 'twitch');
    stubLogin({ login: 'twitch' });
  }
});

test('logged in user sees no follows message', function (assert) {
  assert.expect(2);

  visit(page.url());

  andThen(() => {
    assert.ok(page.noFollows(), 'No follows message');
    assert.equal(page.canonicalUrl(), 'https://www.twitch.tv/directory/following/hosts', 'Canonical URL present');
  });
});

test('track interactivity - logged in user no follows', function (assert) {
  assert.expect(2);

  visit(page.url());

  andThen(function () {
    assert.trackInteractivity('directory.following.hosts');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});

test('logged in user with follows sees no hosts message', function (assert) {
  assert.expect(3);

  followScenario(this.server);

  visit(page.url());

  andThen(() => {
    assert.ok(page.liveHostsTitle(), 'Live Hosts title on the page');
    assert.ok(page.noHosts(), 'No hosts message');
    assert.equal(page.canonicalUrl(), 'https://www.twitch.tv/directory/following/hosts', 'Canonical URL present');
  });
});

test('track interactivity - logged in user no hosts', function (assert) {
  assert.expect(2);

  followScenario(this.server);

  visit(page.url());

  andThen(function () {
    assert.trackInteractivity('directory.following.hosts');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});

test('logged in users with hosts can click to open hosting channel videos list', function (assert) {
  assert.expect(3);

  hostScenario(this.server);

  visit(page.url());

  andThen(() => {
    assert.ok(page.liveHostsTitle(), 'Live Hosts title on the page');

    let link = page.hostedChannelLink();
    assert.ok(link, 'Hosted channel link found');
    click(link);
  });

  andThen(() => {
    assert.equal(page.canonicalUrl(), page.allVideosUrl(), 'transitioned to hosting channel videos list');
  });
});

test('track interactivity - logged in user with hosts', function (assert) {
  assert.expect(2);

  hostScenario(this.server);

  visit(page.url());

  andThen(function () {
    assert.trackInteractivity('directory.following.hosts');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});
