import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import followScenario from 'web-client/mirage/scenarios/follow';
import AllPage from 'web-client/tests/pages/directory/all';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

const loginButtonSelector = '#right-column a[href="/login"]:contains(Log In)';
const signupButtonSelector = '#right-column a[href="/login"]:contains(Sign Up)';
const followSelectorPrefix = '#right-column #js-watchnow-follow .name a';
const recommendedSelectorPrefix = '#right-column #js-watchnow-recs .name a';

moduleForAcceptance('Acceptance | directory/right-column/watch-now', {
  beforeEach() {
    this.experiments.use({ WATCH_NOW_RIGHTBAR: 'treatment' });
    this.page = AllPage.create();
  }
});

test('logged out user has login and signup button', function(assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(() => {
    assert.ok(exists(loginButtonSelector), 'has login button');
    assert.ok(exists(signupButtonSelector), 'has signup button');
  });
});

test('logged in user has no login and signup button', function(assert) {
  stubLogin();
  assert.expect(2);

  visit(this.page.url());

  andThen(() => {
    assert.notOk(exists(loginButtonSelector), 'does not have login button');
    assert.notOk(exists(signupButtonSelector), 'does not have signup button');
  });
});

test('logged in with followers, channels appear in correct sections', function(assert) {
  stubLogin();
  assert.expect(2);

  let follow = followScenario(this.server);

  visit(this.page.url());

  andThen(() => {
    assert.ok(exists(`${followSelectorPrefix}:contains(${follow.channel.display_name})`), 'followed channel exists in following section');
    assert.ok(exists(`${recommendedSelectorPrefix}:contains(Partner)`), 'recommended channel exists in recommendations section');
  });
});

test('logged in without followers, channels appear in correct sections', function(assert) {
  stubLogin();
  assert.expect(2);

  visit(this.page.url());

  andThen(() => {
    assert.notOk(exists(followSelectorPrefix), 'no followed channels exist');
    assert.ok(exists(`${recommendedSelectorPrefix}:contains(Partner)`), 'recommended channel exists in recommendations section');
  });
});

test('logged out, channels appear in correct sections', function(assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(() => {
    assert.notOk(exists(followSelectorPrefix), 'no followed channels exist');
    assert.ok(exists(`${recommendedSelectorPrefix}:contains(Partner)`), 'recommended channel exists in recommendations section');
  });
});

function exists(selector) {
  return find(selector).length > 0;
}
