import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import PageObject from 'web-client/tests/pages/friends-list';
import channelScenario from 'web-client/mirage/scenarios/channel';
let page;

moduleForAcceptance('Acceptance | adding a friend from search', {
  beforeEach() {
    page = PageObject.create();
    this.server.create('user', {name: 'day9tv', display_name: 'day9tv', login: 'day9tv'});
    stubLogin({ login: 'twitch' });
    channelScenario(this.server, 'twitch');
  }
});

test('adding a friend → GET https://api.twitch.tv/kraken/users/:login/friends/requests/:target', function(assert) {
  assert.expect(1);

  this.server.put(`https://api.twitch.tv/kraken/users/:login/friends/requests/:id`, () => {
    assert.ok(true, 'Friend added');
  });

  visit(page.url());
  fillIn(page.friendListInput, 'day');
  keyEvent(page.friendListInput, 'keyup', 13);
  click(page.addFriendButton);
});

test('adding a friend → PUT /friends/requests/:target', function(assert) {
  assert.expect(3);

  this.server.put(`https://api.twitch.tv/kraken/users/:login/friends/requests/:target`, (schema, request) => {
    assert.equal(request.params.login, 'twitch', 'correct :login');
    assert.equal(request.params.target, 'day9tv', 'correct :target');
    return [200, {}, '{}'];
  });

  visit(page.url());
  fillIn(page.friendListInput, 'day');
  keyEvent(page.friendListInput, 'keyup', 13);
  click(page.addFriendButton);

  andThen(() => {
    let $status = find('.js-friend-request-status .svg-close');
    assert.equal($status.length, 1, 'Friend Request Sent');
  });
});


test("adding a friend who's sent you a request simply accepts the request", function(assert) {
  assert.expect(1);

  this.server.get(`https://api.twitch.tv/kraken/users/:login/friends/:id`, function(schema, request) {
    let name = request.params.id;
    let user = schema.db.users.where({name})[0];
    return { friends: false, status: 'requested_by' , user };
  });

  this.server.put(`https://api.twitch.tv/kraken/users/:login/friends/:target`, () => {
    assert.ok(true, 'accepts the request');
    return [204, {}, {}];
  });

  visit(page.url());
  fillIn(page.friendListInput, 'day');
  keyEvent(page.friendListInput, 'keyup', 13);
  click(page.addFriendButton);
});
