import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import friendsListScenario from 'web-client/mirage/scenarios/friends-list';
import PageObject from 'web-client/tests/pages/friends-list';
import channelScenario from 'web-client/mirage/scenarios/channel';

let page;

moduleForAcceptance('Acceptance | friend list properties', {
  beforeEach() {
    page = PageObject.create();
    friendsListScenario(this.server);
    this.server.create('friend', {
      index: 361,
      user_id: 14836307,
      availability: "idle",
      activities: [{
        type: 'none'
      }],
      timestamp: 1448924272
    });
    this.server.create('friend', {
      index: 0,
      user_id: 74936,
      availability: "idle",
      activities: [{
        type: 'none'
      }],
      timestamp: 0
    });
    this.server.create('friend', {
      index: 7,
      user_id: 98274,
      availability: "online",
      activities: [{
        type: 'watching',
        game: 'World of Warcraft',
        channel_login: 'lirik',
        channel_display_name: 'LIRIK'
      }],
      timestamp: 1448924272
    });
    channelScenario(this.server, 'twitch');
    stubLogin({ login: 'twitch'});
  }
});

test('places an online user before idle users', function(assert) {
  assert.expect(2);

  visit(page.url());

  andThen(wait).andThen(() => {
    let rows = find(page.displayName);
    rows = rows.toArray().map(row => row.textContent);
    assert.equal(rows[0], 'totalBiscuit', "totalBiscuit is first because he's online");
  }).andThen(() => {
    assert.ok(/(5)/.test(find(page.openFriendRequestButton).text()), 'div contains notification count 5');
  });
});

test('lists correct status for each user', function(assert) {
  assert.expect(1);

  visit(page.url());
  andThen(wait).andThen(() => {
    let statuses = find('.js-friend-online-status');
    statuses = statuses.toArray().map(row => row.textContent.trim());
    assert.deepEqual(statuses, ['watching LIRIK stream World of Warcraft', 'Idle', 'Idle'], 'displays correct statuses');
  });
});
