import { test, skip } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import friendsListScenario, { createFriends } from 'web-client/mirage/scenarios/friends-list';
import PageObject from 'web-client/tests/pages/friends-list';
import channelScenario from 'web-client/mirage/scenarios/channel';
import { presenceHost } from 'web-client/utilities/presence-util';

let page;

moduleForAcceptance('Acceptance | render a friends list', {
  beforeEach() {
    page = PageObject.create();
    friendsListScenario(this.server);
    createFriends(this.server);
    this.currentUser = stubLogin({ login: 'twitch' });
    channelScenario(this.server, 'twitch');
  },
  afterEach() {
    this.currentUser = null;
  }
});

// TODO figure out why this is passing locally and failing on JENKINS
skip('shows friends list (FAILING ON JENKINS)', function(assert) {
  assert.expect(2);
  visit(page.url());
  andThen(() => {
    let rows = find(page.displayName);
    rows = rows.toArray().map(row => row.textContent);
    assert.deepEqual(rows, ['Day9tv', 'totalBiscuit', 'Yaymukund'], 'displays the correct users');
    assert.ok(/(5)/.test(find(page.openFriendRequestButton).text()), 'div contains notification count 5');
  });
});

// TODO figure out why this is passing locally and failing on JENKINS
skip('Canceling a search (FAILING ON JENKINS)', function(assert) {
  assert.expect(4);

  visit(page.url());

  andThen(() => {
    fillIn(page.friendListInput, 'day');
    keyEvent(page.friendListInput, 'keyup', 13);
  });

  andThen(() => {
    assert.equal(find(page.friendListInput).val(), 'day');
    let list = find(page.displayName).toArray().map(row => row.textContent);
    assert.deepEqual(list, ['Day9tv']);
    click('.js-clear-search');
  });

  andThen(() => {
    assert.equal(find(page.friendListInput).val(), '');
    let list = find(page.displayName).toArray().map(row => row.textContent);
    assert.deepEqual(list, ['Day9tv', 'totalBiscuit', 'Yaymukund']);
  });
});

test('Toggling the friends list cancels search', function(assert) {
  assert.expect(2);

  visit(page.url());
  andThen(() => {
    fillIn(page.friendListInput, 'day');
    keyEvent(page.friendListInput, 'keyup', 13);
  });

  click(page.openFriendRequestButton);
  andThen(() => {
    assert.ok(find('.js-friends-list').hasClass('hidden'), 'friend list is hidden when toggled');
    let list = find('.js-friend-info', '.js-friend-search-results').toArray();
    assert.equal(list.length, 0, 'clears search');
  });
});

test('Sort friends in order of: watching (online), watching (idle), streaming, online (no activity), idle (no activity), and hides offline', function(assert) {
  assert.expect(1);

  this.server.get(`${presenceHost}/v1/friends`, {
    data: [
      { user_id: 12345, activities: [{type: 'none'}], availability: 'offline' },
      { user_id: 87410, activities: [{type: 'broadcasting', game: 'Counter-Strike', channel_login: 'streamer247', channel_display_name: 'STREAMer247'}], availability: 'online' },
      { user_id: 74936, activities: [{type: 'none'}], availability: 'idle' },
      { user_id: 28478, activities: [{type: 'none'}], availability: 'online' },
      { user_id: 54321, activities: [{type: 'watching', game: 'Hearthstone', channel_login: 'nl_kripp', channel_display_name: 'nl_Kripp'}], availability: 'online' },
      { user_id: 10385, activities: [{type: 'none'}], availability: 'online' },
      { user_id: 98765, activities: [{type: 'watching', game: 'World of Warcraft', channel_login: 'lirik', channel_display_name: 'LIRIK'}], availability: 'idle' },
      { user_id: 98274, activities: [{type: 'none'}], availability: 'idle' }
    ]
  });

  this.server.create('friendship-user', {login: 'offline1', id: 12345});
  this.server.create('friendship-user', {login: 'STREAMer247', id: 87410});
  this.server.create('friendship-user', {login: 'idleabc', id: 74936});
  this.server.create('friendship-user', {login: 'onlineKLZ', id: 28478});
  this.server.create('friendship-user', {login: 'onlineWatcheR', id: 54321});
  this.server.create('friendship-user', {login: 'onlineZ', id: 10385});
  this.server.create('friendship-user', {login: 'idle12894', id: 98274});
  this.server.create('friendship-user', {login: 'idleWatcher', id: 98765});

  visit(page.url());
  andThen(() => {
    let rows = find(page.displayName);
    rows = rows.toArray().map(row => row.textContent);
    assert.deepEqual(rows, [
      'onlineWatcheR',
      'idleWatcher',
      'STREAMer247',
      'onlineKLZ',
      'onlineZ',
      'idle12894',
      'idleabc'
    ]);
  });
});
