import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import IndexPage from 'web-client/tests/pages/index';

moduleForAcceptance('Acceptance | Intl I18n', {
  beforeEach() {
    this.experiments.use({ INTL_I18N: 'enabled' });
    this.page = IndexPage.create();
  },
  afterEach() {
    this.experiments.use({ INTL_I18N: 'control' });
  }
});

test('Translations are loadable', function (assert) {
  assert.expect(2);
  visit(this.page.url());
  andThen(() => {
    let $window = find(window)[0];
    assert.ok($window.getTranslations().hasOwnProperty('en-us'));
    assert.equal(find('[href="/p/about"]').text(), 'About');
  });
});

test('Intl Polyfill is loaded', function (assert) {
  assert.expect(1);
  visit(this.page.url());
  andThen(() => {
    let $window = find(window)[0];
    assert.ok($window.hasOwnProperty('Intl'));
  });
});

test('Missing Translation causes event', function (assert) {
  assert.expect(1);
  visit(this.page.url());
  andThen(() => {
    this.owner.lookup('service:intl').t('keyDoesNotExist');
    assert.trackEvent('client_intl_i18n_missing', {key: 'keyDoesNotExist'});
  });
});
