import { test } from 'qunit';
import ChannelPage from '../pages/channel';
import { stubLogin } from '../helpers/stub-login';
import channelScenario from 'web-client/mirage/scenarios/channel';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';

moduleForAcceptance('Acceptance | left navigation', {
  beforeEach() {
    channelScenario(this.server, 'twitch');

    this.page = ChannelPage.create({ name: 'twitch' });

    stubLogin();
  }
});

test('can display all twitch prime offers', function(assert) {
  assert.expect(1);
  this.server.createList('offer', 3);
  visit(this.page.url());

  andThen(function() {
    assert.elementCount('.offer-item', 3);
  });
});

test('clicking on `following` brings you to the following overview', function(assert) {
  assert.expect(2);

  this.experiments.use({ BROWSE_EXPERIMENT: 'variant2' });

  visit('/directory');
  click('.js-left-nav-item:first a');

  andThen(() => {
    assert.equal(currentURL(), '/directory/following');
    assert.equal(currentRouteName(), 'directory.following.index');
  });
});

test('clicking on `browse` brings you to the game directory', function(assert) {
  assert.expect(2);

  this.experiments.use({ BROWSE_EXPERIMENT: 'variant2' });

  visit('/directory/following');
  click('.js-left-nav-item:last a');

  andThen(() => {
    assert.equal(currentURL(), '/directory');
    assert.equal(currentRouteName(), 'directory.games');
  });
});
