import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import { EXPERIMENT_NAME, PERPETUA_ALLOW_GROUP } from 'web-client/utilities/video/playlist';
import CollectionManagerIndexPage from 'web-client/tests/pages/manager/playlists/index';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import managerScenario from 'web-client/mirage/scenarios/manager';
import collectionManagerScenario from 'web-client/mirage/scenarios/manager-playlist';

moduleForAcceptance('Acceptance | /manager/collections [not in experiment]', {
  beforeEach() {
    this.experiments.use({ [EXPERIMENT_NAME]: 'control' });
    this.page = CollectionManagerIndexPage.create();
    managerScenario(this.server);
    stubLogin();
  }
});

test('visiting the collections index', function(assert) {
  assert.expect(2);

  this.experiments.use({ [EXPERIMENT_NAME]: 'nope' });
  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/twitch/manager/past_broadcasts');
    assert.equal(currentRouteName(), 'manager.past-broadcasts.all');
  });
});

moduleForAcceptance('Acceptance | /manager/collections [in experiment]', {
  beforeEach() {
    this.experiments.use({ [EXPERIMENT_NAME]: PERPETUA_ALLOW_GROUP[0] }); // multiple opt in groups exist--choose first
    this.page = CollectionManagerIndexPage.create();
    let { channel } = managerScenario(this.server);
    this.user = stubLogin({ id: channel._id });

    this.collections = collectionManagerScenario(this.server, { owner_id: this.user.id, owner_login: channel.name });
  }
});

test('visiting the collections index', function(assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/twitch/manager/collections');
    assert.equal(currentRouteName(), 'manager.collections.index');
  });
});

test('clicking a collection', function(assert) {
  assert.expect(3);

  visit(this.page.url());

  andThen(() => {
    assert.elementCount(this.page.get('collectionsSelector'), 2, 'should list collections');
  });

  click(`${this.page.get('collectionsSelector')}:first [data-test-selector='edit-playlist-btn']`);

  andThen(() => {
    let firstCollectionId = this.collections[0].id;
    assert.equal(currentURL(), `/twitch/manager/collections/${firstCollectionId}`, 'should transition to the correct collection');
    assert.equal(currentRouteName(), 'manager.collections.edit', 'should transition to the edit route');
  });
});

test('creating a collection', function(assert) {
  assert.expect(2);

  let collectionTitle = 'Top Hits of 2016';

  visit(this.page.url());
  click(this.page.createButtonSelector);
  fillIn(this.page.titleInputSelector, collectionTitle);
  click(this.page.finalizeButtonSelector);

  andThen(() => {
    assert.equal(currentRouteName(), 'manager.collections.edit', 'should transition to the edit route');
    assert.elementText(this.page.editCollectionTitleSelector, collectionTitle);
  });
});
