import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import Page from 'web-client/tests/pages/video-manager/highlighter';
import channelScenario from 'web-client/mirage/scenarios/channel';
import { stubLogin } from '../../helpers/stub-login';

moduleForAcceptance('Acceptance | /manager/highlighter', {
  beforeEach() {
    let username = 'mitchlloyd';
    let channel = channelScenario(this.server, username);
    this.video = this.server.create('video', {
      title: 'My Broadcast',
      description: 'my description',
      tag_list: 'fun,and,games',
      channel
    });
    stubLogin({ login: username });
    this.page = Page.create({ username });
  }
});

test('visiting /:username/manager/v:id/highlight and creating a highlight', function(assert) {
  assert.expect(7);
  visit(this.page.url(this.video));

  let data = {
    startTime: 12,
    endTime: 22,
    title: 'New Highlight',
    description: 'This Rocks'
  };

  fillIn(this.page.startTime, `0:${data.startTime}`);
  fillIn(this.page.endTime, `0:${data.endTime}`);
  click(this.page.describe);
  fillIn(this.page.name, data.title);
  fillIn(this.page.description, data.description);

  click(this.page.submit);

  andThen(() => {
    assert.elementText(this.page.created, 'Highlight Created!');

    let highlight = this.server.schema.videos.where({broadcast_type: 'highlight'}).models[0];
    assert.equal(highlight.start_time, data.startTime, 'start time sent to API');
    assert.equal(highlight.end_time, data.endTime, 'end time sent to API');
    assert.equal(highlight.title, data.title, 'title sent to API');
    assert.equal(highlight.description, data.description, 'description sent to API');

    assert.elementVal(this.page.permalink, `https://www.twitch.tv/${highlight.channel.name}/v/${highlight.id}`, 'permalink');
    assert.ok(find(this.page.embedPlayer).val(), 'embed player');
  });
});
