import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import ManagerIndexPage from 'web-client/tests/pages/manager/index';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import { EXPERIMENT_NAME as COLLECTIONS_EXPERIMENT } from 'web-client/utilities/video/playlist';

moduleForAcceptance('Acceptance | /manager [logged out]', {
  beforeEach() {
    this.page = ManagerIndexPage.create();
  }
});

test('visiting the manager', function(assert) {
  assert.expect(3);

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/twitch/manager/past_broadcasts', 'should have the correct URL');
    assert.equal(currentRouteName(), 'manager.past-broadcasts.all', 'should have the correct route');
    assert.elementCount(this.page.loggedOutMessage(), 1, 'should display the logged out message');
  });
});

moduleForAcceptance('Acceptance | /manager [logged in]', {
  beforeEach() {
    this.page = ManagerIndexPage.create();
    stubLogin();
  }
});

test('visiting /:channel/manager', function(assert) {
  assert.expect(4);

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/twitch/manager/past_broadcasts', 'should have the correct URL');
    assert.equal(currentRouteName(), 'manager.past-broadcasts.all', 'should have the correct route');
    assert.elementCount(this.page.loggedOutMessage(), 0, 'should not display the logged out message');
    assert.elementCount(this.page.collectionsTab(), 0, 'should not show the collections tab');
  });
});

test('clicking the collections tab when in the collections experiment "early" group', function(assert) {
  assert.expect(3);

  this.experiments.use({ [COLLECTIONS_EXPERIMENT]: 'early' });
  visit(this.page.url());

  andThen(() => {
    assert.elementCount(this.page.get('collectionsTabSelector'), 1, 'should show the collections tab');
  });

  click(this.page.get('collectionsTabSelector'));

  andThen(() => {
    assert.equal(currentURL(), '/twitch/manager/collections');
    assert.equal(currentRouteName(), 'manager.collections.index');
  });
});

test('clicking the collections tab when in the collections experiment "mid" group', function(assert) {
  assert.expect(3);

  this.experiments.use({ [COLLECTIONS_EXPERIMENT]: 'mid' });
  visit(this.page.url());

  andThen(() => {
    assert.elementCount(this.page.get('collectionsTabSelector'), 1, 'should show the collections tab');
  });

  click(this.page.get('collectionsTabSelector'));

  andThen(() => {
    assert.equal(currentURL(), '/twitch/manager/collections');
    assert.equal(currentRouteName(), 'manager.collections.index');
  });
});
