/* globals sendIRCMessage, URI */

import { skip } from 'qunit';
import Mirage from 'ember-cli-mirage';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';

import channelScenario from 'web-client/mirage/scenarios/channel';
import ChannelPage from 'web-client/tests/pages/channel';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

const CHANNEL_NAME = 'twitch';
const RESUBSCRIBER_LOGIN = 'resubscriber';
const CUSTOM_MESSAGE = "Great stream! Resubbed!";
const SYSTEM_MESSAGE = `${ RESUBSCRIBER_LOGIN } subscribed for 6 months!`;

moduleForAcceptance('Acceptance | resub notification', {
  beforeEach() {
    this.server.post('http://api.twitch.tv/api/channels/:channel/use_chat_notification_token', (schema, request) => {
      let sendIRCPromise = sendIRCMessage({
        channel: request.params.channel,
        login: RESUBSCRIBER_LOGIN,
        msgId: 'resub',
        params: {
          months: 6
        },
        systemMsg: SYSTEM_MESSAGE,
        text: URI.parseQuery(request.requestBody).custom_message,
        command: 'USERNOTICE'
      });

      sendIRCPromise.then(() => {
        return new Mirage.Response(204, {}, {});
      });
    });

    channelScenario(this.server, CHANNEL_NAME);
    this.page = ChannelPage.create({ name: CHANNEL_NAME });

    stubLogin({ login: RESUBSCRIBER_LOGIN });
  }
});

skip('sharing a custom resub notification message', function (assert) {
  assert.expect(3);

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${ CHANNEL_NAME }`, 'visits the correct channel');
  });

  fillIn(this.page.resubNotifInput, CUSTOM_MESSAGE);
  click(this.page.resubSecondShareButton);

  andThen(() => {
    assert.ok(this.page.hasResubUserNoticeSystemMessage(SYSTEM_MESSAGE), 'chat has resub system message');
    assert.ok(this.page.hasResubUserNoticeCustomMessage(CUSTOM_MESSAGE), 'chat has resub custom message');
  });
});
