import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';

moduleForAcceptance('Acceptance | /email-verification/:opaque_id', {
});

test('visiting email verification page renders failure when visage endpoint fails', function(assert) {
  assert.expect(2);

  visit('/email-verification/error');

  andThen(() => {
    assert.elementCount('[data-test-selector="verify-error"]', 1, "Couldn't find the error message");
    assert.elementText('[data-test-selector="verify-error"]', "Couldn't validate your email: Not Found", 'Unexpected error message');
  });
});

test('visiting email verification page renders success when visage endpoint succeeds', function(assert) {
  assert.expect(2);

  visit('/email-verification/success');

  andThen(() => {
    assert.elementCount('[data-test-selector="verify-success"]', 1, "Couldn't find the success message");
    assert.elementText('[data-test-selector="verify-success"]', "Your email address has been successfully validated.", 'Unexpected success message');
  });
});
