import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import ExtensionConfigPage from 'web-client/tests/pages/settings/extension-config';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

moduleForAcceptance('Acceptance | /settings/extensions/:extension_id/configure', {
  beforeEach() {
    this.page = ExtensionConfigPage.create();
    this.server.create('extension-installation', { channelId: '12345' });
  }
});

test('visiting extension configuration redirects to default settings page when not in EXTENSIONS experiment', function(assert) {
  assert.expect(1);

  stubLogin();

  visit(this.page.url());

  andThen(() => {
    assert.notEqual(currentURL(), this.page.url());
  });
});

test('visiting extension configuration redirects to default settings page when in EXTENSIONS experiment, but not logged in as staff', function(assert) {
  assert.expect(1);

  stubLogin();
  this.experiments.use({ EXTENSIONS: 'yes' });

  visit(this.page.url());

  andThen(() => {
    assert.notEqual(currentURL(), this.page.url());
  });
});

test('visiting extension configuration loads properly when in EXTENSIONS experiment as staff', function(assert) {
  assert.expect(1);

  stubLogin({ is_staff: true });
  this.experiments.use({ EXTENSIONS: 'yes' });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), this.page.url());
  });
});


test('visiting extension configuration redirects away when visiting for non-installed extension.', function(assert) {
  assert.expect(1);

  stubLogin({ id: '55555', login: 'not_twitch', is_staff: true });
  this.experiments.use({ EXTENSIONS: 'yes' });

  visit(this.page.url());

  andThen(() => {
    assert.notEqual(currentURL(), this.page.url());
  });
});
