/* globals Twitch */
import { test } from 'qunit';
import sinon from 'sinon';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';

moduleForAcceptance('Acceptance | bootstrap navgation search', {
  afterEach() {
    $('[data-component=navigation-search]').remove();
  }
});

test('injecting header search', function(assert) {
  assert.expect(2);

  $('#ember-testing').append(`
    <div data-component="navigation-search"
         data-attrs='{"isInHeader": true}'>Search placeholder</div>
  `);

  visit('/private/embed-components');

  andThen(function() {
    assert.equal(
      find('[data-component=navigation-search] [data-test-selector=navigation-search-field]').length,
      1,
      "New search element added inside of target element"
    );
  });

  fillIn('[data-test-selector=navigation-search-field] input', 'dummy');

  andThen(function() {
    assert.ok(find('#search-panel').hasClass('search-panel--fly'), "animates downward");
  });
});

test('injecting sidebar search', function(assert) {
  assert.expect(2);

  $('#ember-testing').append(`
    <div data-component="navigation-search"
         data-attrs='{"isInHeader": false}'>Search placeholder</div>
  `);

  visit('/private/embed-components');

  andThen(function() {
    assert.equal(
      find('[data-component=navigation-search] [data-test-selector=navigation-search-field]').length,
      1,
      "New search element added inside of target element"
    );
  });

  fillIn('[data-test-selector=navigation-search-field] input', 'dummy');

  andThen(function() {
    assert.ok(find('#search-panel').hasClass('search-panel--slide'), "animates from the left");
  });
});

test('supressing page tracking', function(assert) {
  assert.expect(1);

  let stub = sinon.stub(Twitch.tracking.funnel, 'trackPageView');

  $('#ember-testing').append(`
    <div data-component="navigation-search"
         data-attrs='{"isInHeader": false}'>Search placeholder</div>
  `);

  visit('/private/embed-components');

  andThen(function() {
    assert.equal(stub.callCount, 0, "did not track this transition as a pageview event");
  });
});
