import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import channelScenario from 'web-client/mirage/scenarios/channel';
import ChannelPage from '../../pages/channel';
import { lastPlayerInstance } from 'web-client/tests/helpers/fake-player';

let layoutService;

moduleForAcceptance('Acceptance | search | player interactions', {
  beforeEach() {
    channelScenario(this.server, 'twitch');
    this.page = ChannelPage.create({ name: 'twitch' });
    layoutService = this.owner.lookup('service:layout');
  }
});

test("opening search exits the player's theater mode", function(assert) {
  assert.expect(1);

  visit(this.page.url());

  andThen(function() {
    lastPlayerInstance.setTheatre(true);
  });

  // press alt+f
  triggerEvent('#player', 'keydown', { altKey: true, keyCode: 70 });

  andThen(function() {
    assert.equal(layoutService.isTheatreMode, false, "player is no longer in theater mode");
  });
});
