import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import ExtensionDetailsPage from 'web-client/tests/pages/settings/extension-details';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

moduleForAcceptance('Acceptance | /settings/extensions/:extension_id', {
  beforeEach() {
    this.page = ExtensionDetailsPage.create();
    this.server.create('extension', {
      id: 'fake_extension',
      version: '1.0'
    });
  }
});

test('visiting extension details redirects to default settings page when not in EXTENSIONS experiment', function(assert) {
  assert.expect(1);

  stubLogin();

  visit(this.page.url());

  andThen(() => {
    assert.notEqual(currentURL(), this.page.url());
  });
});

test('visiting extension details redirects to default settings page when in EXTENSIONS experiment, but not logged in as staff', function(assert) {
  assert.expect(1);

  stubLogin();
  this.experiments.use({ EXTENSIONS: 'yes' });

  visit(this.page.url());

  andThen(() => {
    assert.notEqual(currentURL(), this.page.url());
  });
});

test('visiting extension details loads properly when in EXTENSIONS experiment as staff', function(assert) {
  assert.expect(1);

  stubLogin({ is_staff: true });
  this.experiments.use({ EXTENSIONS: 'yes' });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), this.page.url());
  });
});
