import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import videoScenario from 'web-client/mirage/scenarios/video';
import VodPage from 'web-client/tests/pages/vod';
import channelScenario from 'web-client/mirage/scenarios/channel';

moduleForAcceptance('Acceptance | vod', {
  beforeEach() {
    this.video = videoScenario(this.server, { channel: channelScenario(this.server) });
    this.page = VodPage.create({ vodId: this.video.id });
    this.rechatService = this.owner.lookup('service:vod-chat-service');
  }
});

test('visiting vod page should redirect to videos page', function(assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/videos/${this.video.id}`);
    assert.equal(currentRouteName(), 'videos');
  });
});

