import QUnit from 'qunit';
import moment from 'moment';

export const TEST_DATE_FORMAT = "YYYY-MM-DD HH:mm:ss";
/*
  Assert that 2 dates are similar

 @method assert.datesMatch
 @param {String|Date} firstDate
 @param {String|Date} secondDate
*/
QUnit.assert.datesMatch = function(firstDate, secondDate, message) {
  let firstDateString = moment(firstDate, TEST_DATE_FORMAT).format(TEST_DATE_FORMAT);
  let secondDateString = moment(secondDate, TEST_DATE_FORMAT).format(TEST_DATE_FORMAT);

  this.pushResult({
    result: firstDateString === secondDateString,
    actual: firstDateString,
    expected: secondDateString,
    message: message || `Expected "${firstDateString}" to match "${secondDateString}".`
  });
};
