import QUnit from 'qunit';
import getOwner from 'ember-owner/get';

function _getOwner() {
  let context = QUnit.config.current.testEnvironment;

  // getOwner(context) is set by ember-qunit for integration and unit tests
  // context.owner is set by our tests/helpers/module-for-acceptance.js for acceptance tests
  return getOwner(context) || context.owner;
}

/**
 * Usage:
 * ```
 *   assert.didNotify('Video successfully uploaded');
 * ```
 */
QUnit.assert.didNotify = function(notifyText) {
  let invocations = _getOwner().lookup('service:notify')._invocations;
  let result = invocations.indexOf(notifyText) !==-1;

  let message;
  if (result) {
    message = `did notify "${notifyText}"`;
  } else {
    message = `failed, expected "${notifyText}" to be in ${QUnit.dump.parse(invocations)}`;
  }

  this.pushResult({
    result,
    actual: result,
    expected: true,
    message
  });
};
