import QUnit from 'qunit';

/*
  Assert that a string includes another string.

  Example:

  ```js
  assert.stringIncludes('abcdefg', 'def');
  ```

 @method assert.stringIncludes
 @param {String} stringToSearch The string to search for stringToFind
 @param {String} stringToFind The string to find in stringToSearch
*/
QUnit.assert.stringIncludes = function(stringToSearch, stringToFind, message) {
  this.pushResult({
    result: stringToSearch.indexOf(stringToFind) !== -1,
    actual: stringToSearch,
    expected: stringToFind,
    message: message || `Expected "${stringToSearch}" to include "${stringToFind}".`
  });
};

/*
  Assert that a string does not include another string.

  Example:

  ```js
  assert.notStringIncludes('team', 'i');
  ```

 @method assert.stringIncludes
 @param {String} stringToSearch The string to search for stringToFind
 @param {String} stringToFind The string that should not be found in stringToSearch
*/
QUnit.assert.notStringIncludes = function(stringToSearch, stringToFind, message) {
  this.pushResult({
    result: stringToSearch.indexOf(stringToFind) === -1,
    actual: stringToSearch,
    expected: stringToFind,
    message: message || `Expected "${stringToSearch}" to not include "${stringToFind}".`
  });
};
