import { helper } from 'ember-helper';
import { typeOf } from 'ember-utils';

export function getBitsString(key, defaultString, ...args) {
  let output = {};

  output['key'] = key;
  if (defaultString) {
    output['defaultString'] = defaultString;
  }
  if (args && args[0] && typeOf(args[0]) === 'object') {
    output['args'] = args[0];
  }

  return JSON.stringify(output);
}

export default helper(([key, defaultString, ...args]) => {
  return getBitsString(key, defaultString, ...args);
});
