import QUnit from 'qunit';
import getOwner from 'ember-owner/get';

function _getOwner() {
  let context = QUnit.config.current.testEnvironment;

  // getOwner(context) is set by ember-qunit for integration and unit tests
  // context.owner is set by our tests/helpers/module-for-acceptance.js for acceptance tests
  return getOwner(context) || context.owner;
}

export function initializeChat() {
  let controller = _getOwner().lookup('controller:chat');
  let tmiRoom = controller.get('currentRoom.tmiRoom');
  tmiRoom._trigger('entered');
}
