/*
 * Mock an API for window.cookie
 *
 * https://git-aws.internal.justin.tv/web/web/blob/39c88c601541782bece718abb7c21ff26d1ca707/vendor/assets/javascripts/cookie.js
 */
export default class CookieMock {
  constructor() {
    this._storage = {};
  }
  get(key) {
    return this._storage[key];
  }
  set(key, value) {
    this._storage[key] = value;
    return this;
  }
  remove(key) {
    delete this._storage[key];
  }
}
