import $ from 'jquery';
import { assign } from 'ember-platform';

/*
* Dispatch key events. Note that legacy `createEvent` APIs are used since
* Chrome has a long-standing bug around setting a keyCode with the modern APIs.
*/
export default function dispatchKeyEvent(type, options={}) {
  let target = document;
  if (options.target) {
    target = options.target;
    delete options.target;
  }
  let event = document.createEvent('Events');
  event.initEvent(
    type,
    options.hasOwnProperty('canBubble') && options.canBubble,
    options.hasOwnProperty('cancelable') && options.cancelable
  );
  assign(event, options);
  $(target)[0].dispatchEvent(event);
}
