import { test } from 'ember-qunit';
import Ember from 'ember';
import Service from 'ember-service';
const { RSVP } = Ember;

export const FakeExperimentService = Service.extend({
  init() {
    this._super(...arguments);
    this.experimentsHash = {};
  },

  getExperimentValue(key) {
    return RSVP.resolve(this.peekValue(key));
  },

  peekValue(key) {
    return this.experimentsHash[key];
  },

  use(hash) {
    this.experimentsHash = hash;
  }
});

/* eslint-disable qunit/require-expect */
export default function experimentGroupTest(description, { values, experiment, test: testFunction }) {
  values.forEach(function(value) {

    test(['EXPERIMENT GROUP TEST', description, value].join(' - '), function(assert) {
      this.owner.register('service:experiments', FakeExperimentService);
      this.owner.lookup('service:experiments').use({ [experiment]: value });
      return testFunction.call(this, assert);
    });
  });
}
