export let lastPlayerInstance;

export default class FakePlayer {
  constructor(domId, { video, channel }) {
    this.video = video;
    this.channel = channel;
    this.isInTheaterMode = false;
    this.listeners = {};
    this.clipRecorded = false;
    this.trackingProperties = {};
    this.miniPlayerMode = false;
    lastPlayerInstance = this;
  }

  setVideo(video) {
    this.video = video;
  }

  setChannel(channel) {
    this.channel = channel;
  }

  setTrackingProperties(properties) {
    this.trackingProperties = properties;
  }

  addEventListener(eventName, fn) {
    let eventListeners = this.listeners[eventName];
    if (!eventListeners) {
      eventListeners = this.listeners[eventName] = [];
    }

    eventListeners.push(fn);
  }

  removeEventListener(eventName, fn) {
    let eventListeners = this.listeners[eventName];
    if (eventListeners) {
      this.listeners[eventName] = eventListeners.without(fn);
    }
  }

  setTheatre(bool) {
    /**
      We're imitating a bug in the player here.
      The order of these 2 commands should be reversed after this issue is closed.
      https://twitchtv.atlassian.net/browse/VP-696
    */
    trigger(this.listeners, 'theatrechange', bool);
    this.isInTheaterMode = bool;
  }

  getTheatre() {
    return this.isInTheaterMode;
  }

  trackMiniPlayerAction() {
  }

  destroy() {
    lastPlayerInstance = null;
    this.listeners = {};
  }

  recordClip() {
    this.clipRecorded = true;
  }

  trigger(eventName, ...args) {
    trigger(this.listeners, eventName, ...args);
  }

  setMiniPlayerMode(value) {
    this.miniPlayerMode = value;
  }
}

function trigger(listeners, eventName, ...args) {
  let eventListeners = listeners[eventName] || [];
  eventListeners.forEach((fn) => fn(...args));
}
