function replacePlusWithSpace(string) {
  return string.replace(/\+/g, ' ');
}

// Replace "+" in QUnit filtering config values with " " (space).
// Fixes an issue where filtering for module or test names with spaces fails
// because URI.js (used in globals.js, from web/web)
// normalizes spaces to pluses in the query params before QUnit reads them,
// and QUnit does not decode pluses back to spaces before filtering.
// Note: This makes it impossible to filter for a module/test name with a
// literal plus in it.
// This issue is fixed in QUnit (see https://github.com/jquery/qunit/pull/1001)
// and will be in QUnit 2.0.
//
// When web-client is on QUnit 2.0 PR #970 and PR #997 can be removed altogether.
export default function fixQUnitParams(QUnit) {
  ['filter', 'module'].forEach((key) => {
    let value = QUnit.config[key];
    if (value) {
      QUnit.config[key] = replacePlusWithSpace(value);
    }
  });
}
