import Service from 'ember-service';
import RSVP from 'rsvp';
import computed from 'ember-computed';

export default Service.extend({
  listMap: computed('list', function() {
    return this.get('list').reduce((obj, channel) => {
      obj[channel.name] = true;
      return obj;
    }, {});
  }),

  init() {
    this._super(...arguments);

    this.set('isLoaded', true);
    this.set('settings', {});
    this.set('list', []);
    this.set('autoHostedBy', []);
    this.set('newAutoHostedBy', []);
    this.set('status', {});
    this.set('snoozed', false);
    this.set('isAutoHosting', false);
  },

  setSettings(key, value) {
    this.set(`settings.${key}`, value);
    return RSVP.resolve(this.get('settings'));
  },

  updateList() {
    return RSVP.resolve(this.get('list'));
  },

  setList(ids) {
    let list = ids.map((id) => ({
      _id: id,
      name: `autohost-target-${id}`,
      displayName: `Autohost Target ${id}`
    }));
    this.set('list', list);
    return RSVP.resolve(list);
  },

  addChannelToList(channelID) {
    let list = this.get('list');
    let channel = {
      _id: channelID,
      name: `autohost-target-${channelID}`,
      displayName: `Autohost Target ${channelID}`
    };
    list.push(channel);
    this.set('list', list);
    return RSVP.resolve(list);
  },

  removeChannelFromList(channelID) {
    let list = this.get('list').filter((channel) => channel._id !== channelID);
    this.set('list', list);
    return RSVP.resolve(list);
  },

  updateAutoHostedBy() {
    let newAutoHostedBy = this.get('newAutoHostedBy');
    this.set('autoHostedBy', newAutoHostedBy);
    return RSVP.resolve(newAutoHostedBy);
  },

  updateStatus() {
    return RSVP.resolve(this.get('status'));
  },

  snooze() {
    this.set('snoozed', true);
  },

  unsnooze() {
    this.set('snoozed', false);
  }
});
