/* globals Twitch */
let originalIdsForMixpanel;
let uniqueId;

export function setup() {
  originalIdsForMixpanel = Twitch.idsForMixpanel;

  let _getOrCreateId = () => {
    if (!uniqueId) {
      uniqueId = `mixpanel-unique-testing-id-${Math.random()}`;
    }
    return uniqueId;
  };

  // See https://git-aws.internal.justin.tv/web/web/blob/master/app/assets/javascripts/twitch/identifiers.js
  Twitch.idsForMixpanel = {
    getOrCreateUniqueId:               _getOrCreateId,
    createUniqueId:                    _getOrCreateId,
    getOrCreateSessionUniqueId:        _getOrCreateId,
    getOrCreateLocalStorageUniqueId:   _getOrCreateId,
    getOrCreateSessionStorageUniqueId: _getOrCreateId
  };
}

export function teardown() {
  Twitch.idsForMixpanel = originalIdsForMixpanel;
  uniqueId = null;
}

/**
 * Use in tests to force the mixpanel id to be a certain value
 */
export function stubMixpanelId(val) {
  uniqueId = val;
}
