import Service from 'ember-service';

export default Service.extend({
  isMini: false,
  isFullSize: true,
  canBeFullSize: false,
  lockedInFullSize: false,

  playerDimensions: {
    height: 600,
    width: 900,
    targetWidth: 900
  },

  persistentPlayerLocation: {
    top: 0,
    left: 0
  },

  fullSizePlayerLocation: {
    top: 400,
    left: 0
  },

  animationCoords: {
    position: 'fixed',
    originX: 0,
    originY: 0,
    translateX: 100,
    translateY: 100,
    scaleX: 0.5,
    scaleY: 0.5
  },

  setMini(value) {
    this.isMini = value;
    this.isFullSize = !value;
  }
});
