import EmberObject from 'ember-object';
import Service from 'ember-service';
import RSVP from 'rsvp';
import { JTV_USER_PICTURES_404_USER_70X70_URL } from 'web-client/utilities/urls/static-cdn';
import { UnauthenticatedError } from 'web-client/utilities/error';

export default Service.extend({
  isAuthenticated: false
});

export let userData = {
  id: 1,
  login: 'twitch',
  name: 'Twitch',
  has_turbo: false,
  has_premium: false,
  is_staff: false,
  is_admin: false,
  is_broadcaster: false
};

let primeUserData = {
  id: 2,
  login: 'twitch-prime',
  name: 'Twitch Prime',
  has_turbo: true,
  has_premium: true,
  is_staff: false,
  is_admin: false,
  is_broadcaster: false
};

let userModel = EmberObject.create({
  id: 'twitch',
  displayName: 'Twitch',
  logo: JTV_USER_PICTURES_404_USER_70X70_URL
});

let primeUserModel = EmberObject.create({
  id: 'twitch-prime',
  displayName: 'Twitch Prime',
  logo: JTV_USER_PICTURES_404_USER_70X70_URL
});

export const AuthenticatedSession = Service.extend({
  isAuthenticated: true,
  userData,
  userModel,

  getCurrentUser() {
    return RSVP.resolve(userData);
  },

  getOAuthToken() {
    return RSVP.resolve('oauthtokenwoot');
  },

  withCurrentUser(callback) {
    return callback(userData);
  }
});

export const UnAuthenticatedSession = Service.extend({
  isAuthenticated: false,
  userData: null,
  userModel: null,

  getCurrentUser() {
    return RSVP.reject(new UnauthenticatedError());
  },

  getOAuthToken() {
    return RSVP.resolve(''); // Unauthenticated returns empty string, not null or undefined.
  },

  withCurrentUser(callback) {
    return callback(userData);
  }
});

export const AuthenticatedSessionWithPrime = Service.extend({
  isAuthenticated: true,
  userData: primeUserData,
  userModel: primeUserModel,

  getCurrentUser() {
    return RSVP.resolve(primeUserData);
  },

  getOAuthToken() {
    return RSVP.resolve('oauthtoken-with-prime');
  },

  withCurrentUser(callback) {
    return callback(userData);
  }
});
