import TrackingService from 'web-client/services/tracking';

export default TrackingService.extend({
  _invocations: null,

  init() {
    this._super(...arguments);
    this._invocations = [];
    this.benchmark._invocations = [];
  },

  trackEvent(options) {
    this._invocations.push(options);
  },

  resetInvocations() {
    this._invocations = [];
    this.benchmark._invocations = [];
  },

  benchmark: {
    _invocations: null,

    _firstPageLoad: true,

    end() {},

    getSession() {
      return 12345;
    },

    transition(phase = 'execute', properties = {}) {
      this.track(`${phase}_transition`, properties);
    },

    track(name, data) {
      this._invocations.push({ name, data });
    }
  }
});
