/* globals Twitch */
import Ember from 'ember';
let originalTracking;

const { K } = Ember ;

export function setup() {
  originalTracking = Twitch.tracking;

  let spadeAndMixpanel = function() { return this; };
  spadeAndMixpanel.trackEvent = K;


  Twitch.tracking = {
    spadeAndMixpanel,
    sendComscoreBeacon: K,
    sendGermanBeacons: K,

    funnel: {
      addCampaignTracking: K,
      addProperties: K,
      // disable debug logging while testing
      debugEnabled() { return false; },
      trackPageView: K,
      trackPageViewWithDiagnostics: K
    },

    gaq: {
      trackVirtualPageView: K
    },

    log: {
      trackEvent: K
    },

    mixpanel: {
      sendMixpanelBeacon: K,
      setGameClickVars: K,
      trackDiscovery: K,
      trackEvent: K,
      trackGameClick: K
    },

    spade: {
      trackEvent: K
    }
  };
}

export function teardown() {
  Twitch.tracking = originalTracking;
}
