import mirageInitializer from 'web-client/initializers/ember-cli-mirage';
import getServer from 'web-client/mirage/get-server';
import { setup as setupIframeXHRs, teardown as teardownIframeXHRs } from './override-iframe-xhr';

/**
 * These setup and teardown methods can be used to start a Mirage server
 * in non-acceptance tests
 */
export function setup(testContext) {
  mirageInitializer.initialize(testContext.container);
  testContext._stubbedIframes = setupIframeXHRs();
  testContext.server = getServer();
}

export function teardown(testContext) {
  testContext.server.shutdown();
  teardownIframeXHRs(testContext._stubbedIframes);
}
