import Ember from 'ember';
const { K, Object: EmberObject } = Ember;

const FakeTMISession = EmberObject.extend({
  on: K,
  getRoom() {
    return {
      done(callback) {
        callback(this);
      }
    };
  },
  isIgnored() { return false; },
  destroy: K
});

export function stubTMI(context) {
  context.oldTMI = window.TMI;

  window.TMI = {
    createSession() {
      return FakeTMISession.create();
    }
  };

  return window.TMI;
}

export function restoreTMI(context) {
  window.TMI = context.oldTMI;
}
