import { stubLogout, stubLoginModal } from 'web-client/tests/helpers/stub-login';

// Visits the given url while logged-out and asserts that the login modal/overlay
// is displayed. If the optional `expectedText` property is passed, this also
// makes an assertion that that text is displayed.
export default function testForLoginModal({ url, testFunction, expectedText }) {
  return testFunction(`visiting "${url}" while logged-out shows login modal`, function(assert) {
    let assertions = expectedText ? 2 : 1;
    assert.expect(assertions);

    stubLogout();
    let stubbedModal = stubLoginModal();

    visit(url);
    andThen(() => {
      assert.ok(stubbedModal.isDisplayed, 'displays login modal');

      if (expectedText) {
        assert.ok(find(`*:contains(${expectedText})`).length,
                  'Shows not-logged-in message');
      }
    });
  });
}
