import wait from 'ember-test-helpers/wait';

/**
 * This function returns a promise that interleaves `wait()` calls between
 * function calls. This is a little more ergonomic for stringing together
 * steps that must wait in an integration test. This should not be used
 * in acceptance tests where better alternatives exist.
 *
 * @param {...function} fns - A list of functions
 * @returns {Promise}
 */
export default function waitBetween(...fns) {
  return fns.reduce((promise, fn) => {
    return promise.then((result) => {
      return wait(fn(result));
    });
  }, wait());
}
