import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import AutohostUI from 'web-client/tests/pages/autohost-settings';

moduleForComponent('autohost-settings:recommended-channel', {
  beforeEach() {
    this.ui = new AutohostUI(this);
  }
});

test('renders', function (assert) {
  assert.expect(1);

  this.set('addAction', () => {});
  this.render(hbs`{{autohost-settings/recommended-channel addAction=(action addAction)}}`);

  return wait().then(() => {
    assert.equal(this.ui.recommendedResults().length, 1, 'appears');
    return wait();
  });
});

test('hits the action with the user', function (assert) {
  assert.expect(10);

  let user = {blah: 'what'};
  this.set('user', user);
  let addedChannels = [];
  let sources = [];
  this.set('addAction', (channel, source) => {
    addedChannels.push(channel);
    sources.push(source);
    this.set('inList', true);
  });
  let removedChannels = [];
  this.set('undoAction', (channel) => {
    removedChannels.push(channel);
    this.set('inList', false);
  });
  this.set('inList', false);
  this.render(hbs`{{autohost-settings/recommended-channel user=user inList=inList source='blah' addAction=(action addAction) undoAction=(action undoAction)}}`);

  return wait().then(() => {
    assert.equal(this.ui.recommendedResults().length, 1, 'appears');
    this.ui.recommendedResultsAddButtons().click();
    return wait();
  }).then(() => {
    assert.equal(addedChannels.length, 1, 'action was called');
    assert.deepEqual(addedChannels[0], user, 'user was used as parameter');
    assert.equal(sources[0], 'blah', 'correct source');
    assert.equal(this.ui.recommendedResultsRemoveButtons().length, 1, 'remove button shown');
    assert.equal(this.ui.recommendedResultsAddButtons().length, 0, 'add button gone');
    this.ui.recommendedResultsRemoveButtons().click();
    return wait();
  }).then(() => {
    assert.equal(removedChannels.length, 1, 'action was called');
    assert.deepEqual(removedChannels[0], user, 'user was used as parameter');
    assert.equal(this.ui.recommendedResultsRemoveButtons().length, 0, 'remove button gone');
    assert.equal(this.ui.recommendedResultsAddButtons().length, 1, 'add button shown');
    return wait();
  });
});

test('disabled if inList', function (assert) {
  assert.expect(2);

  this.set('addAction', () => {});
  this.render(hbs`{{autohost-settings/recommended-channel inList=true addAction=(action addAction) undoAction=(action addAction)}}`);

  return wait().then(() => {
    assert.equal(this.ui.recommendedResults().length, 1, 'appears');
    assert.equal(this.ui.recommendedResultsRemoveButtons().length, 1, 'remove button shown');
    return wait();
  });
});
