import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('backpack/ticket-subscription', 'Integration | Component | backpack ticket subscription', {
  integration: true
});

test('Only one support button balloon can be open', function(assert) {
  assert.expect(3);

  this.set('ticket', {
    'product': {
      'partner': {
        'isLoading': false
      },
      'recurring': true,
      'features': {
        'bitrate_access': []
      },
      'emoticons': []
    },
    'purchase_profile': {
      'will_renew': false,
      'refundable': true
    }
  });
  this.render(hbs`
    {{backpack/ticket-subscription ticket=ticket}}
  `);

  let $profileActions = this.$().find('.js-ticket__actions');
  let $buttons = $profileActions.find('button');

  assert.equal($buttons.length, 2, 'There are 2 buttons');
  $buttons.each((idx, $obj) => {
    $obj.click();
    assert.equal($profileActions.find('.balloon.show').length, 1, `Clicking on #${idx} button shows 1 balloon`);
  });
});
