import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('backpack/benefit-info-button', 'Integration | Component | backpack/benefit info button', {
  integration: true
});

test('Extend backpack/support-button', function(assert) {
  assert.expect(3);

  this.set('openedBalloon', 'benefitInfo');
  this.set('toggleBalloon', (name) => {
    assert.equal(`Toggling ${name}`, 'Toggling benefitInfo', 'toggleBalloon is invoked');
  });

  this.render(hbs`
    {{backpack/benefit-info-button openedBalloon=openedBalloon toggleBalloon=toggleBalloon}}
  `);

  assert.ok($('.balloon-wrapper.profile-actions__button'), 'classNames is correct');
  assert.ok($('.balloon.show'), 'openedBalloon is true');

  // this does another assert
  this.$().find('button').click();
});

test('Content verification', function(assert) {
  assert.expect(3);

  this.set('ticket', {
    'access_end': '2016-01-01T12:00:00Z'
  });

  this.render(hbs`
    {{backpack/benefit-info-button ticket=ticket}}
  `);

  assert.equal(this.$('button').text().trim(), 'Benefit Info', 'Button label');
  assert.equal(this.$('.content h5').text().trim(), 'Benefits will end on:', 'Balloon label');
  assert.equal(this.$('.content span').text().trim(), 'Jan 1, 2016', 'Access end date');
});
